import useSwr from "swr";
import { fetchLogs } from "../lib/actions.client";

export function useOtpLogs(startDate: string, endDate: string) {
  const { data, error, isValidating } = useSwr(
    [startDate, endDate],
    async () => {
      return fetchLogs(startDate, endDate);
    }
  );

  return {
    data,
    isLoading: !error && !data,
    error,
    isValidating,
  };
}
